<?php
header('Content-Type: application/json');
require_once '../includes/site_data.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit;
}

// Get and validate input
$name = sanitizeInput($_POST['name'] ?? '');
$email = sanitizeInput($_POST['email'] ?? '');
$phone = sanitizeInput($_POST['phone'] ?? '');
$subject = sanitizeInput($_POST['subject'] ?? '');
$budget = sanitizeInput($_POST['budget'] ?? '');
$message = sanitizeInput($_POST['message'] ?? '');
$newsletter_signup = isset($_POST['newsletter']);

// Validation
$errors = [];

if (empty($name)) {
    $errors[] = 'Name is required';
}

if (empty($email)) {
    $errors[] = 'Email is required';
} elseif (!validateEmail($email)) {
    $errors[] = 'Please enter a valid email address';
}

if (empty($subject)) {
    $errors[] = 'Subject is required';
}

if (empty($message)) {
    $errors[] = 'Message is required';
}

if (!empty($errors)) {
    echo json_encode(['success' => false, 'message' => implode(', ', $errors)]);
    exit;
}

// Save contact message
$contact_data = [
    'name' => $name,
    'email' => $email,
    'phone' => $phone,
    'subject' => $subject,
    'budget' => $budget,
    'message' => $message,
    'newsletter_signup' => $newsletter_signup
];

$message_saved = saveContactMessage($contact_data);

// Add to newsletter if requested
if ($newsletter_signup) {
    addNewsletterSubscriber($email);
}

if ($message_saved) {
    echo json_encode([
        'success' => true,
        'message' => 'Thank you for your message! I\'ll get back to you soon.'
    ]);
} else {
    echo json_encode([
        'success' => false,
        'message' => 'Sorry, there was an error sending your message. Please try again.'
    ]);
}
?>
