<?php
require_once 'config/database.php';

function getPortfolioItems($category = null, $featured_only = false, $limit = null) {
    $pdo = getDBConnection();
    
    $sql = "SELECT * FROM portfolio_items WHERE status = 'active'";
    $params = [];
    
    if ($category) {
        $sql .= " AND category = ?";
        $params[] = $category;
    }
    
    if ($featured_only) {
        $sql .= " AND is_featured = 1";
    }
    
    $sql .= " ORDER BY display_order ASC, created_at DESC";
    
    if ($limit) {
        $sql .= " LIMIT ?";
        $params[] = $limit;
    }
    
    try {
        $stmt = $pdo->prepare($sql);
        $stmt->execute($params);
        return $stmt->fetchAll();
    } catch(PDOException $e) {
        error_log("Error fetching portfolio items: " . $e->getMessage());
        return [];
    }
}

function getPortfolioCategories() {
    $pdo = getDBConnection();
    
    try {
        $stmt = $pdo->query("SELECT DISTINCT category FROM portfolio_items WHERE status = 'active' ORDER BY category");
        return $stmt->fetchAll(PDO::FETCH_COLUMN);
    } catch(PDOException $e) {
        error_log("Error fetching portfolio categories: " . $e->getMessage());
        return [];
    }
}

function getPortfolioItem($id) {
    $pdo = getDBConnection();
    
    try {
        $stmt = $pdo->prepare("SELECT * FROM portfolio_items WHERE id = ? AND status = 'active'");
        $stmt->execute([$id]);
        return $stmt->fetch();
    } catch(PDOException $e) {
        error_log("Error fetching portfolio item: " . $e->getMessage());
        return null;
    }
}

function getCategoryDisplayName($category) {
    $categories = [
        'pamphlets' => 'Pamphlet Designs',
        'events' => 'Event Welcome Signs',
        'promotions' => 'Restaurant & School',
        'brands' => 'Brand Posters'
    ];
    
    return $categories[$category] ?? ucfirst($category);
}
?>
