<?php
require_once 'config/database.php';

echo "Setting up admin user...\n";

try {
    $pdo = getDBConnection();
    
    // Check if admin user already exists
    $stmt = $pdo->prepare("SELECT COUNT(*) as count FROM users WHERE username = 'admin'");
    $stmt->execute();
    $count = $stmt->fetch()['count'];
    
    if ($count > 0) {
        // Update existing admin user with new password
        $password_hash = password_hash('password', PASSWORD_DEFAULT);
        $stmt = $pdo->prepare("UPDATE users SET password = ? WHERE username = 'admin'");
        $stmt->execute([$password_hash]);
        echo "✅ Admin user password updated successfully!\n";
    } else {
        // Create new admin user
        $password_hash = password_hash('password', PASSWORD_DEFAULT);
        $stmt = $pdo->prepare("INSERT INTO users (username, email, password) VALUES ('admin', 'admin@portfolio.com', ?)");
        $stmt->execute([$password_hash]);
        echo "✅ Admin user created successfully!\n";
    }
    
    echo "\n📋 Admin Login Credentials:\n";
    echo "Username: admin\n";
    echo "Password: password\n";
    echo "\n🔗 Admin Panel URL: http://localhost/dashboard/Manisha/admin/login.php\n";
    echo "\n⚠️  Please change the default password after first login!\n";
    
} catch(PDOException $e) {
    echo "❌ Error setting up admin user: " . $e->getMessage() . "\n";
}
?>
